@echo off
chcp 65001>nul

:QueryOsLanguage
set INSTALL_LANG=en
for /f "tokens=3" %%L in ('reg query "HKCU\Control Panel\International" /v LocaleName') do set INSTALL_LANG=%%L
if not "%INSTALL_LANG%"=="en" for /f "tokens=1 delims=-" %%L in ("%INSTALL_LANG%") do set INSTALL_LANG=%%L

:SetLanguageStrings
if exist install-strings-%INSTALL_LANG%.bat (
	call install-strings-%INSTALL_LANG%.bat
) else (
	echo.
	echo No language file for your language "%INSTALL_LANG%" was found. English will be used instead.
	if exist install-strings-en.bat (
		call install-strings-en.bat
	) else (
		echo.
		echo Error: Language file "install-strings-en.bat" was found.
		pause
		goto :EOF
	)
)

echo.
echo   ***************************************************************
echo   *                                                             *
echo   *  %strWelcomeMessage%  *
echo   *                                                             *
echo   ***************************************************************

:LoadInputVars
call :LoadInputVar LANG
call :LoadInputVar HOST
call :LoadInputVar INSTALLDIR
call :LoadInputVar USER
call :LoadInputVar PASS

if not "%LANG%"=="" if not "%HOST%"=="" if not "%USER%"=="" if not "%PASS%"=="" goto :Menu

:InputLang
echo.
echo %strQuestionLanguage%
echo de = Deutsch
echo en = English
echo X = %strExit%
set INPUT=%LANG%
set /p INPUT=%strInput% [%INPUT%] ^> 

if "%INPUT%"=="" goto :InputLang
if /i "%INPUT%"=="x" goto :EOF

if not exist "install\%INPUT%\*" (
	echo.
	echo %strErrorLanguageXDoesntExist1% "%INPUT%" %strErrorLanguageXDoesntExist2%
	goto :InputLang
)

call :SaveInputVar LANG

:InputHost
echo.
echo %strQuestionInputHost%
echo X = %strExit%
set INPUT=%HOST%
set /p INPUT=%strInput% [%INPUT%] ^> 
if "%INPUT%"=="" goto :InputHost
if /i "%INPUT%"=="x" goto :EOF
call :SaveInputVar HOST

:InputInstallDir
echo.
echo %strQuestionInputInstallDir%
echo %strHintInputInstallDir%
echo X = %strExit%
set INPUT=%INSTALLDIR%
set /p INPUT=%strInput% [%INPUT%] ^> 
if /i "%INPUT%"=="x" goto :EOF
call :SaveInputVar INSTALLDIR

:InputUserName
echo.
echo %strQuestionInputUser%
echo X = %strExit%
set INPUT=%USER%
set /p INPUT=%strInput% [%INPUT%] ^> 
if "%INPUT%"=="" goto :InputUserName
if /i "%INPUT%"=="x" goto :EOF
call :SaveInputVar USER

:InputPassword
echo.
echo %strQuestionInputPass%
echo X = %strExit%
set INPUT=%PASS%
set /p INPUT=%strInput% [%INPUT%] ^> 
if "%INPUT%"=="" goto :InputPassword
if /i "%INPUT%"=="x" goto :EOF
call :SaveInputVar PASS

:Menu
echo.
echo ———————— %strSummaryHeading% ————————
echo.
echo %strSummaryLanguage%  %LANG%
echo %strSummaryHost%  %HOST%
echo %strSummaryInstallDir%  %INSTALLDIR%
echo %strSummaryUser%  %USER%
echo %strSummaryPass%  %PASS%
echo.
echo %strQuestionWhatToTo%
echo L = %strListInstallDir%
echo N = %strNewInstallation%
echo U = %strUpdateInstallation%
echo H = %strDeleteHtaccess%
echo E = %strEnterNewValues%
echo I = %strShowReadme%
echo X = %strExit%

set INPUT=
set /p INPUT=%strInput% ^> 
if "%INPUT%"=="" goto :Menu
if /i "%INPUT%"=="l" goto :ListInstallDir
if /i "%INPUT%"=="n" goto :Install
if /i "%INPUT%"=="u" goto :Update
if /i "%INPUT%"=="h" goto :Htaccess
if /i "%INPUT%"=="e" goto :InputLang
if /i "%INPUT%"=="i" goto :Readme
if /i "%INPUT%"=="x" goto :EOF

echo.
echo %strWrongInput%
goto :Menu

:ListInstallDir
call :InitSftpCommandFile
if not "%ERROR%"=="" goto :Menu
(
	echo dir "%INSTALLDIR%"
	echo exit
)>sftp.txt
call :RunSFTP
goto :Menu

:Install
set UPLOADDIR=install
goto :UploadFiles

:Update
set UPLOADDIR=update
goto :UploadFiles

:UploadFiles
call :InitSftpCommandFile
if not "%ERROR%"=="" goto :Menu
(
	if not "%INSTALLDIR%"=="" echo cd "%INSTALLDIR%"
	echo mput -r "%UPLOADDIR%/common/*"
	echo mput -r "%UPLOADDIR%/%LANG%/*"
	echo chmod 755 lib/cgi-bin/*.pl
	echo exit
)>sftp.txt
call :RunSFTP
echo.
if errorlevel 1 (
	echo %strErrorDuringUploadToWebserver%
) else (
	echo %strInfoInstallationCompleted%
)
goto :Menu

:InitSftpCommandFile
	set ERROR=
	if exist sftp.txt del sftp.txt
	if exist sftp.txt (
		echo.
		echo %strErrorDeletingExistingSftpTxtFile%
		set ERROR=1
	)
goto :EOF

:RunSFTP
	if exist PSFTP.EXE (
		.\PSFTP.EXE -l "%USER%" -pw "%PASS%" -b sftp.txt "%HOST%"
	) else (
		echo.
		echo %strErrorPsftpExeWasNotFound%
	)
goto :EOF

:Htaccess
call :InitSftpCommandFile
if not "%ERROR%"=="" goto :Menu
(
	echo del "%INSTALLDIR%/lib/.htaccess"
	echo exit
)>sftp.txt
call :RunSFTP
goto :Menu

:Readme
more < readme-%LANG%.txt
goto :Menu

:LoadInputVar
	set VAR_NAME=%~1
	set %VAR_NAME%=
	(for /f "tokens=3*" %%V in ('reg query "HKCU\SOFTWARE\Stefan Bion\BlogInstaller" /v "%VAR_NAME%"') do set %VAR_NAME%=%%V) 2>nul
goto :EOF

:SaveInputVar
	set VAR_NAME=%~1
	set %VAR_NAME%=%INPUT%
	reg add "HKCU\SOFTWARE\Stefan Bion\BlogInstaller" /v "%VAR_NAME%" /d "%INPUT%" /f >nul
goto :EOF
