<?php
	$timeStart = microtime(true);

	ini_set('display_errors', 1);
	ini_set('display_startup_errors', 1);
	error_reporting(E_ALL);

	include_once 'lib/config.php';
	include 'lib/default.php';
	InitDefault();
?>
<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
<?php if (!empty($base)) echo "	<base href=\"$base\" />\n"; ?>
	<meta charset="UTF-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />

	<link rel="alternate" href="feed.rss" type="application/rss+xml" title="<?php echo $websiteName; ?>" />
	<link rel="icon" href="<?php echo $cssVars['--WebsiteIcon']; ?>" />
	<link rel="apple-touch-icon" href="<?php echo $cssVars['--WebsiteIcon']; ?>" />
	<meta name="msapplication-TileImage" content="<?php echo $cssVars['--WebsiteIcon']; ?>" />

	<title><?php echo $htmlTitle; ?></title>
	<meta name="description" content="<?php echo $htmlDescription; ?>" />
	<meta name="keywords" content="<?php echo get_tags(); ?>" />
	<meta name="generator" content="Blog4u - https://www.stefanbion.de/blog4u" />

	<meta property="article:published_time" content="<?php echo get_date(); ?>" />
	<meta property="article:modified_time" content="<?php echo date('Y-m-d', getlastmod()); ?>" />

	<meta property="og:type" content="article" />
	<meta property="og:title" content="<?php echo $htmlTitle; ?>" />
	<meta property="og:description" content="<?php echo $htmlDescription; ?>" />
	<meta property="og:image" content="<?php echo "$baseUrl/" . get_image(); ?>" />
	<meta property="og:locale" content="<?php echo $locale; ?>" />
	<meta property="og:site_name" content="<?php echo $websiteName; ?>" />

	<meta name="twitter:card" content="summary_large_image" />
	<meta name="twitter:title" content="<?php echo $htmlTitle; ?>" />
	<meta name="twitter:description" content="<?php echo $htmlDescription; ?>" />
	<meta name="twitter:image" content="<?php echo "$baseUrl/" . get_image(); ?>" />

	<style>
		<?php if (ExistsStylesheet()) include 'lib/' . GetStylesheet(); ?>
		<?php if (ExistsUserStylesheet()) include 'lib/' . GetUserStylesheet(); ?>
	</style>

	<script>
		<?php include 'lib/default.js'; ?>
		document.addEventListener('DOMContentLoaded', InitDefault);
	</script>
</head>

<body>
	<aside class="menu-left-space"></aside>
	<nav>
		<div class="logo"><a href="<?php echo $baseUrl; ?>"><?php echo $websiteName; ?></a></div>
		<div class="menu"><?php PrintMenu(); ?></div>
	</nav>
	<aside class="menu-right-space"></aside>

	<header>
		<p><?php echo $headerTitle; ?></p>
		<p><?php echo NoWrap($headerSubtitle); ?></p>
	</header>

	<aside class="left-space"></aside>

	<main>
		<?php DisplayMainContentBegin(); ?>
