<?php
	function FillWidgetLosung()
	{
		global $locale;

		// Losungsdaten ermitteln - Download der Losungsdatei unter: https://www.losungen.de/download
		$formatter = new IntlDateFormatter($locale, IntlDateFormatter::NONE, IntlDateFormatter::NONE);
		$formatter->setPattern("'media/losungen'yyyy'.xml'");
		$filename = $formatter->format(time());

		$xmlLosungen = file_get_contents($filename);
		if (!$xmlLosungen)
		{
			echo "<p>Fehler: Datei \"$filename\" konnte nicht gelesen werden.</p>";
			return;
		}

		$losungen = new SimpleXMLElement($xmlLosungen);

		$formatter = new IntlDateFormatter($locale, IntlDateFormatter::NONE, IntlDateFormatter::NONE);
		$formatter->setPattern("yyyy-MM-dd'T00:00:00'");
		$losungDate = $formatter->format(time());

		$found = false;
		foreach ($losungen->Losungen as $losung)
		{
		//	if ((string) $losung->Datum === $losungDate)
			if (str_contains((string) $losung->Datum, $losungDate))
			{
				$losungZitat = LosungTextToHtml((string) $losung->Losungstext);
				$losungVers = (string) $losung->Losungsvers;
				$lehrversZitat = LosungTextToHtml((string) $losung->Lehrtext);
				$lehrversVers = (string) $losung->Lehrtextvers;

				$found = true;
				break;
			}
		}

		if (!$found)
		{
			echo "<p>Fehler: Keine Losung für heute gefunden.</p>";
			return;
		}

		$formatter = new IntlDateFormatter($locale, IntlDateFormatter::NONE, IntlDateFormatter::NONE);
		$formatter->setPattern("'Für' EEEE', den' dd.MM.yyyy");
		$displayDate = $formatter->format(time());

		// Ausgabe
		echo '<p class="losung-datum">' . $displayDate . '</p>';
		echo '<p class="losung-zitat">' . $losungZitat . '</p>';
		echo '<p class="losung-vers"><a href="https://www.bibleserver.com/LUT/' . $losungVers . '" target="_blank" rel="noopener" title="Auf bibleserver.com nachschlagen">' . $losungVers . '</a></p>';
		echo '<p class="losung-zitat">' . $lehrversZitat . '</p>';
		echo '<p class="losung-vers"><a href="https://www.bibleserver.com/LUT/' . $lehrversVers . '" target="_blank" rel="noopener" title="Auf bibleserver.com nachschlagen">' . $lehrversVers . '</a></p>';
		echo '<p class="losung-copy"><a href="https://www.ebu.de/" target="_blank" rel="noopener" title="Evangelische Brüder-Unität">&copy; Evangelische Brüder-Unität &ndash; Herrnhuter Brüdergemeine.</a> <a href="https://www.losungen.de/" target="_blank" rel="noopener" title="www.losungen.de">Weitere Informationen hier.</a></p>';
		echo '<p class="losung-link"><a href="https://www.cza.de/veroeffentlichungen/gedanken-zur-tageslosung/" target="_blank" rel="noopener" title="Christus Zentrum Arche">Gedanken zur Tageslosung</a></p>';
	}

	function LosungTextToHtml($text)
	{
		$text = preg_replace('#/(.*?)/#', '<span class="losung-einleitung">$1</span>', $text);
		$text = preg_replace('/#(.*?)#/', '<span class="losung-betont">$1</span>', $text);
		return $text;
	}

	FillWidgetLosung();
?>
