<!-- Widget "Neueste Beiträge" -->

<?php
	function FillRecentPosts()
	{
		global $fileTypes;
		global $filePublished;
		global $fileDates;
		global $fileTitles;

		$maxItems = 10;
		$numItems = 0;

		if (count($fileDates) > 0)
		{
			echo '<ul>';

			foreach ($fileDates as $file => $date)
			{
				$type = def_type($fileTypes[$file] ?? null);
				$published = def_published($filePublished[$file] ?? null);
				$title = def_title($fileTitles[$file] ?? null);

				if ($type === 'post' && $published)
				{
					echo '<li><a href="' . MakeLink($file) . '">' . $title . '</a></li>';
					if (++$numItems >= $maxItems) break;
				}
			}
			echo '</ul>';
		}
	}

	FillRecentPosts();
?>
